#use Date::Manip;

sub main'getseconds {
  local($datestr) = @_;
  local($date, $sec);

  # Look for the number of seconds to be in parenthesis on the date line.
  if($datestr =~ /\((\d+)\)/) {
    return $1;
  }

  if($datestr = /^\s*$/) {
    return 0;
  }

  # Otherwise, parse the date string.
  if(!(($datestr =~ /[A-Z][A-Z][A-Z]/) || ($datestr =~ /-\d\d\d/))) {
    $datestr .= " EDT";
  }
  $datestr =~ s:\(.*\)::;

  $date = &ParseDate($datestr);
  $sec = &UnixDate($date, %s);

  $sec;
}

sub main'read_file {
  local($file)= @_;

  open(FOO, "<$file");
  
  %header=();
  while(<FOO>) {
    chop;
    last if(/^\s*$/);
    if(/^(\S*):\s*(.*)\s*/) {
      ($h = $1) =~ tr:A-Z:a-z:;
      $header{$h} = $2;
    }
  }
  close(FOO);
}

sub read_files {
  local($dir) = @_;
  local(@allfiles, $f);

  opendir(DIR, $dir);
  @allfiles = grep(/^\d+$/, readdir(DIR));
  closedir(DIR);

  @allfiles;
}

sub main'get_header {
  local($head) = @_;
  $head =~ tr:A-Z:a-z:;
  $header{$head};
}

1;
